package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN, ReportJobId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReportJob(
    reportJobId: Option[ReportJobId] = None,
    reportPlanArn: Option[ARN] = None,
    reportTemplate: Option[String] = None,
    creationTime: Option[Timestamp] = None,
    completionTime: Option[Timestamp] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    reportDestination: Option[zio.aws.backup.model.ReportDestination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportJob = {
    import ReportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportJob
      .builder()
      .optionallyWith(
        reportJobId.map(value => ReportJobId.unwrap(value): java.lang.String)
      )(_.reportJobId)
      .optionallyWith(
        reportPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.reportPlanArn)
      .optionallyWith(reportTemplate.map(value => value: java.lang.String))(
        _.reportTemplate
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(reportDestination.map(value => value.buildAwsValue()))(
        _.reportDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportJob.ReadOnly =
    zio.aws.backup.model.ReportJob.wrap(buildAwsValue())
}
object ReportJob {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.ReportJob] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportJob =
      zio.aws.backup.model.ReportJob(
        reportJobId.map(value => value),
        reportPlanArn.map(value => value),
        reportTemplate.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        reportDestination.map(value => value.asEditable)
      )
    def reportJobId: Option[ReportJobId]
    def reportPlanArn: Option[ARN]
    def reportTemplate: Option[String]
    def creationTime: Option[Timestamp]
    def completionTime: Option[Timestamp]
    def status: Option[String]
    def statusMessage: Option[String]
    def reportDestination
        : Option[zio.aws.backup.model.ReportDestination.ReadOnly]
    def getReportJobId: ZIO[Any, AwsError, ReportJobId] =
      AwsError.unwrapOptionField("reportJobId", reportJobId)
    def getReportPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("reportPlanArn", reportPlanArn)
    def getReportTemplate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reportTemplate", reportTemplate)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getReportDestination
        : ZIO[Any, AwsError, zio.aws.backup.model.ReportDestination.ReadOnly] =
      AwsError.unwrapOptionField("reportDestination", reportDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportJob
  ) extends zio.aws.backup.model.ReportJob.ReadOnly {
    override val reportJobId: Option[ReportJobId] = scala
      .Option(impl.reportJobId())
      .map(value => zio.aws.backup.model.primitives.ReportJobId(value))
    override val reportPlanArn: Option[ARN] = scala
      .Option(impl.reportPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val reportTemplate: Option[String] =
      scala.Option(impl.reportTemplate()).map(value => value: String)
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionTime: Option[Timestamp] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val reportDestination
        : Option[zio.aws.backup.model.ReportDestination.ReadOnly] = scala
      .Option(impl.reportDestination())
      .map(value => zio.aws.backup.model.ReportDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportJob
  ): zio.aws.backup.model.ReportJob.ReadOnly = new Wrapper(impl)
}
