package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN, BackupVaultName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BackupVaultListMember(
    backupVaultName: Option[BackupVaultName] = None,
    backupVaultArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None,
    encryptionKeyArn: Option[ARN] = None,
    creatorRequestId: Option[String] = None,
    numberOfRecoveryPoints: Option[Long] = None,
    locked: Option[Boolean] = None,
    minRetentionDays: Option[Long] = None,
    maxRetentionDays: Option[Long] = None,
    lockDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupVaultListMember = {
    import BackupVaultListMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupVaultListMember
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        numberOfRecoveryPoints.map(value => value: java.lang.Long)
      )(_.numberOfRecoveryPoints)
      .optionallyWith(locked.map(value => value: java.lang.Boolean))(_.locked)
      .optionallyWith(minRetentionDays.map(value => value: java.lang.Long))(
        _.minRetentionDays
      )
      .optionallyWith(maxRetentionDays.map(value => value: java.lang.Long))(
        _.maxRetentionDays
      )
      .optionallyWith(lockDate.map(value => Timestamp.unwrap(value): Instant))(
        _.lockDate
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupVaultListMember.ReadOnly =
    zio.aws.backup.model.BackupVaultListMember.wrap(buildAwsValue())
}
object BackupVaultListMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupVaultListMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupVaultListMember =
      zio.aws.backup.model.BackupVaultListMember(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        creationDate.map(value => value),
        encryptionKeyArn.map(value => value),
        creatorRequestId.map(value => value),
        numberOfRecoveryPoints.map(value => value),
        locked.map(value => value),
        minRetentionDays.map(value => value),
        maxRetentionDays.map(value => value),
        lockDate.map(value => value)
      )
    def backupVaultName: Option[BackupVaultName]
    def backupVaultArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def encryptionKeyArn: Option[ARN]
    def creatorRequestId: Option[String]
    def numberOfRecoveryPoints: Option[Long]
    def locked: Option[Boolean]
    def minRetentionDays: Option[Long]
    def maxRetentionDays: Option[Long]
    def lockDate: Option[Timestamp]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getNumberOfRecoveryPoints: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("numberOfRecoveryPoints", numberOfRecoveryPoints)
    def getLocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("locked", locked)
    def getMinRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minRetentionDays", minRetentionDays)
    def getMaxRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxRetentionDays", maxRetentionDays)
    def getLockDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lockDate", lockDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupVaultListMember
  ) extends zio.aws.backup.model.BackupVaultListMember.ReadOnly {
    override val backupVaultName: Option[BackupVaultName] = scala
      .Option(impl.backupVaultName())
      .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val encryptionKeyArn: Option[ARN] = scala
      .Option(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creatorRequestId: Option[String] =
      scala.Option(impl.creatorRequestId()).map(value => value: String)
    override val numberOfRecoveryPoints: Option[Long] =
      scala.Option(impl.numberOfRecoveryPoints()).map(value => value: Long)
    override val locked: Option[Boolean] =
      scala.Option(impl.locked()).map(value => value: Boolean)
    override val minRetentionDays: Option[Long] =
      scala.Option(impl.minRetentionDays()).map(value => value: Long)
    override val maxRetentionDays: Option[Long] =
      scala.Option(impl.maxRetentionDays()).map(value => value: Long)
    override val lockDate: Option[Timestamp] = scala
      .Option(impl.lockDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupVaultListMember
  ): zio.aws.backup.model.BackupVaultListMember.ReadOnly = new Wrapper(impl)
}
