package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait CopyJobState {
  def unwrap: software.amazon.awssdk.services.backup.model.CopyJobState
}
object CopyJobState {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.CopyJobState
  ): zio.aws.backup.model.CopyJobState = value match {
    case software.amazon.awssdk.services.backup.model.CopyJobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.CopyJobState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.backup.model.CopyJobState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.backup.model.CopyJobState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.CopyJobState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.CopyJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.CopyJobState =
      software.amazon.awssdk.services.backup.model.CopyJobState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.backup.model.CopyJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.CopyJobState =
      software.amazon.awssdk.services.backup.model.CopyJobState.CREATED
  }
  case object RUNNING extends zio.aws.backup.model.CopyJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.CopyJobState =
      software.amazon.awssdk.services.backup.model.CopyJobState.RUNNING
  }
  case object COMPLETED extends zio.aws.backup.model.CopyJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.CopyJobState =
      software.amazon.awssdk.services.backup.model.CopyJobState.COMPLETED
  }
  case object FAILED extends zio.aws.backup.model.CopyJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.CopyJobState =
      software.amazon.awssdk.services.backup.model.CopyJobState.FAILED
  }
}
