package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CopyAction(
    lifecycle: Option[zio.aws.backup.model.Lifecycle] = None,
    destinationBackupVaultArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CopyAction = {
    import CopyAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CopyAction
      .builder()
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .destinationBackupVaultArn(
        ARN.unwrap(destinationBackupVaultArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CopyAction.ReadOnly =
    zio.aws.backup.model.CopyAction.wrap(buildAwsValue())
}
object CopyAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.CopyAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CopyAction =
      zio.aws.backup.model.CopyAction(
        lifecycle.map(value => value.asEditable),
        destinationBackupVaultArn
      )
    def lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly]
    def destinationBackupVaultArn: ARN
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getDestinationBackupVaultArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(destinationBackupVaultArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CopyAction
  ) extends zio.aws.backup.model.CopyAction.ReadOnly {
    override val lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val destinationBackupVaultArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.destinationBackupVaultArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CopyAction
  ): zio.aws.backup.model.CopyAction.ReadOnly = new Wrapper(impl)
}
