package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{TagValue, TagKey, ARN}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ARN,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.TagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.TagResourceRequest.ReadOnly =
    zio.aws.backup.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.TagResourceRequest =
      zio.aws.backup.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ARN
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.TagResourceRequest
  ) extends zio.aws.backup.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.backup.model.primitives
          .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.TagResourceRequest
  ): zio.aws.backup.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
