package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StartBackupJobResponse(
    backupJobId: Option[String] = None,
    recoveryPointArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartBackupJobResponse = {
    import StartBackupJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartBackupJobResponse
      .builder()
      .optionallyWith(backupJobId.map(value => value: java.lang.String))(
        _.backupJobId
      )
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartBackupJobResponse.ReadOnly =
    zio.aws.backup.model.StartBackupJobResponse.wrap(buildAwsValue())
}
object StartBackupJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartBackupJobResponse =
      zio.aws.backup.model.StartBackupJobResponse(
        backupJobId.map(value => value),
        recoveryPointArn.map(value => value),
        creationDate.map(value => value)
      )
    def backupJobId: Option[String]
    def recoveryPointArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def getBackupJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupJobId", backupJobId)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ) extends zio.aws.backup.model.StartBackupJobResponse.ReadOnly {
    override val backupJobId: Option[String] =
      scala.Option(impl.backupJobId()).map(value => value: String)
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ): zio.aws.backup.model.StartBackupJobResponse.ReadOnly = new Wrapper(impl)
}
