package zio.aws.backup.model
import java.time.Instant
import zio.aws.backup.model.primitives.{
  Timestamp,
  BackupVaultName,
  ResourceType,
  MaxResults,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByBackupVaultRequest(
    backupVaultName: BackupVaultName,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None,
    byResourceArn: Option[ARN] = None,
    byResourceType: Option[ResourceType] = None,
    byBackupPlanId: Option[String] = None,
    byCreatedBefore: Option[Timestamp] = None,
    byCreatedAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest = {
    import ListRecoveryPointsByBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.byResourceArn)
      .optionallyWith(
        byResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.byResourceType)
      .optionallyWith(byBackupPlanId.map(value => value: java.lang.String))(
        _.byBackupPlanId
      )
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest =
      zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest(
        backupVaultName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        byResourceArn.map(value => value),
        byResourceType.map(value => value),
        byBackupPlanId.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def byResourceArn: Option[ARN]
    def byResourceType: Option[ResourceType]
    def byBackupPlanId: Option[String]
    def byCreatedBefore: Option[Timestamp]
    def byCreatedAfter: Option[Timestamp]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("byResourceArn", byResourceArn)
    def getByResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("byResourceType", byResourceType)
    def getByBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("byBackupPlanId", byBackupPlanId)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ) extends zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byResourceArn: Option[ARN] = scala
      .Option(impl.byResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val byResourceType: Option[ResourceType] = scala
      .Option(impl.byResourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val byBackupPlanId: Option[String] =
      scala.Option(impl.byBackupPlanId()).map(value => value: String)
    override val byCreatedBefore: Option[Timestamp] = scala
      .Option(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Option[Timestamp] = scala
      .Option(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ): zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly =
    new Wrapper(impl)
}
