package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait StorageClass {
  def unwrap: software.amazon.awssdk.services.backup.model.StorageClass
}
object StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.StorageClass
  ): zio.aws.backup.model.StorageClass = value match {
    case software.amazon.awssdk.services.backup.model.StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.StorageClass.WARM =>
      val r = WARM
      r
    case software.amazon.awssdk.services.backup.model.StorageClass.COLD =>
      val r = COLD
      r
    case software.amazon.awssdk.services.backup.model.StorageClass.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.StorageClass =
      software.amazon.awssdk.services.backup.model.StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object WARM extends zio.aws.backup.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.StorageClass =
      software.amazon.awssdk.services.backup.model.StorageClass.WARM
  }
  case object COLD extends zio.aws.backup.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.StorageClass =
      software.amazon.awssdk.services.backup.model.StorageClass.COLD
  }
  case object DELETED extends zio.aws.backup.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.StorageClass =
      software.amazon.awssdk.services.backup.model.StorageClass.DELETED
  }
}
