package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBackupPlanTemplatesResponse(
    nextToken: Option[String] = None,
    backupPlanTemplatesList: Option[
      Iterable[zio.aws.backup.model.BackupPlanTemplatesListMember]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse = {
    import ListBackupPlanTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        backupPlanTemplatesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupPlanTemplatesList)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly =
    zio.aws.backup.model.ListBackupPlanTemplatesResponse.wrap(buildAwsValue())
}
object ListBackupPlanTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlanTemplatesResponse =
      zio.aws.backup.model.ListBackupPlanTemplatesResponse(
        nextToken.map(value => value),
        backupPlanTemplatesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def backupPlanTemplatesList: Option[
      List[zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBackupPlanTemplatesList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backupPlanTemplatesList",
      backupPlanTemplatesList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ) extends zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val backupPlanTemplatesList: Option[
      List[zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly]
    ] = scala
      .Option(impl.backupPlanTemplatesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.BackupPlanTemplatesListMember.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ): zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
