package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ResourceType, ARN}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProtectedResource(
    resourceArn: Option[ARN] = None,
    resourceType: Option[ResourceType] = None,
    lastBackupTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ProtectedResource = {
    import ProtectedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ProtectedResource
      .builder()
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        lastBackupTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastBackupTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ProtectedResource.ReadOnly =
    zio.aws.backup.model.ProtectedResource.wrap(buildAwsValue())
}
object ProtectedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ProtectedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ProtectedResource =
      zio.aws.backup.model.ProtectedResource(
        resourceArn.map(value => value),
        resourceType.map(value => value),
        lastBackupTime.map(value => value)
      )
    def resourceArn: Option[ARN]
    def resourceType: Option[ResourceType]
    def lastBackupTime: Option[Timestamp]
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getLastBackupTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastBackupTime", lastBackupTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ProtectedResource
  ) extends zio.aws.backup.model.ProtectedResource.ReadOnly {
    override val resourceArn: Option[ARN] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val lastBackupTime: Option[Timestamp] = scala
      .Option(impl.lastBackupTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ProtectedResource
  ): zio.aws.backup.model.ProtectedResource.ReadOnly = new Wrapper(impl)
}
