package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class UpdateRecoveryPointLifecycleRequest(
    backupVaultName: BackupVaultName,
    recoveryPointArn: ARN,
    lifecycle: Option[zio.aws.backup.model.Lifecycle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest = {
    import UpdateRecoveryPointLifecycleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest.ReadOnly =
    zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest
      .wrap(buildAwsValue())
}
object UpdateRecoveryPointLifecycleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest =
      zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest(
        backupVaultName,
        recoveryPointArn,
        lifecycle.map(value => value.asEditable)
      )
    def backupVaultName: BackupVaultName
    def recoveryPointArn: ARN
    def lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest
  ) extends zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
    override val lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest
  ): zio.aws.backup.model.UpdateRecoveryPointLifecycleRequest.ReadOnly =
    new Wrapper(impl)
}
