package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN, BackupVaultName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateBackupVaultResponse(
    backupVaultName: Option[BackupVaultName] = None,
    backupVaultArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse = {
    import CreateBackupVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly =
    zio.aws.backup.model.CreateBackupVaultResponse.wrap(buildAwsValue())
}
object CreateBackupVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupVaultResponse =
      zio.aws.backup.model.CreateBackupVaultResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        creationDate.map(value => value)
      )
    def backupVaultName: Option[BackupVaultName]
    def backupVaultArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse
  ) extends zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly {
    override val backupVaultName: Option[BackupVaultName] = scala
      .Option(impl.backupVaultName())
      .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse
  ): zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly = new Wrapper(impl)
}
