package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.BackupPlanName
import scala.jdk.CollectionConverters._
final case class BackupPlanInput(
    backupPlanName: BackupPlanName,
    rules: Iterable[zio.aws.backup.model.BackupRuleInput],
    advancedBackupSettings: Option[
      Iterable[zio.aws.backup.model.AdvancedBackupSetting]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupPlanInput = {
    import BackupPlanInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupPlanInput
      .builder()
      .backupPlanName(BackupPlanName.unwrap(backupPlanName): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.advancedBackupSettings)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupPlanInput.ReadOnly =
    zio.aws.backup.model.BackupPlanInput.wrap(buildAwsValue())
}
object BackupPlanInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupPlanInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupPlanInput =
      zio.aws.backup.model.BackupPlanInput(
        backupPlanName,
        rules.map { item =>
          item.asEditable
        },
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPlanName: BackupPlanName
    def rules: List[zio.aws.backup.model.BackupRuleInput.ReadOnly]
    def advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]]
    def getBackupPlanName: ZIO[Any, Nothing, BackupPlanName] =
      ZIO.succeed(backupPlanName)
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.backup.model.BackupRuleInput.ReadOnly
    ]] = ZIO.succeed(rules)
    def getAdvancedBackupSettings: ZIO[Any, AwsError, List[
      zio.aws.backup.model.AdvancedBackupSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "advancedBackupSettings",
      advancedBackupSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupPlanInput
  ) extends zio.aws.backup.model.BackupPlanInput.ReadOnly {
    override val backupPlanName: BackupPlanName =
      zio.aws.backup.model.primitives.BackupPlanName(impl.backupPlanName())
    override val rules: List[zio.aws.backup.model.BackupRuleInput.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.backup.model.BackupRuleInput.wrap(item)
        }
        .toList
    override val advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]] =
      scala
        .Option(impl.advancedBackupSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.AdvancedBackupSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupPlanInput
  ): zio.aws.backup.model.BackupPlanInput.ReadOnly = new Wrapper(impl)
}
