package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBackupVaultsResponse(
    backupVaultList: Option[
      Iterable[zio.aws.backup.model.BackupVaultListMember]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse = {
    import ListBackupVaultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse
      .builder()
      .optionallyWith(
        backupVaultList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupVaultList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly =
    zio.aws.backup.model.ListBackupVaultsResponse.wrap(buildAwsValue())
}
object ListBackupVaultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupVaultsResponse =
      zio.aws.backup.model.ListBackupVaultsResponse(
        backupVaultList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backupVaultList
        : Option[List[zio.aws.backup.model.BackupVaultListMember.ReadOnly]]
    def nextToken: Option[String]
    def getBackupVaultList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupVaultListMember.ReadOnly
    ]] = AwsError.unwrapOptionField("backupVaultList", backupVaultList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse
  ) extends zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly {
    override val backupVaultList
        : Option[List[zio.aws.backup.model.BackupVaultListMember.ReadOnly]] =
      scala
        .Option(impl.backupVaultList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.BackupVaultListMember.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse
  ): zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly = new Wrapper(impl)
}
