package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ResourceType
import scala.jdk.CollectionConverters._
final case class GetSupportedResourceTypesResponse(
    resourceTypes: Option[Iterable[ResourceType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse = {
    import GetSupportedResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse
      .builder()
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly =
    zio.aws.backup.model.GetSupportedResourceTypesResponse.wrap(buildAwsValue())
}
object GetSupportedResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetSupportedResourceTypesResponse =
      zio.aws.backup.model
        .GetSupportedResourceTypesResponse(resourceTypes.map(value => value))
    def resourceTypes: Option[List[ResourceType]]
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse
  ) extends zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly {
    override val resourceTypes: Option[List[ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.primitives.ResourceType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse
  ): zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
