package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCopyJobRequest(copyJobId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest = {
    import DescribeCopyJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest
      .builder()
      .copyJobId(copyJobId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeCopyJobRequest.ReadOnly =
    zio.aws.backup.model.DescribeCopyJobRequest.wrap(buildAwsValue())
}
object DescribeCopyJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeCopyJobRequest =
      zio.aws.backup.model.DescribeCopyJobRequest(copyJobId)
    def copyJobId: String
    def getCopyJobId: ZIO[Any, Nothing, String] = ZIO.succeed(copyJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest
  ) extends zio.aws.backup.model.DescribeCopyJobRequest.ReadOnly {
    override val copyJobId: String = impl.copyJobId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest
  ): zio.aws.backup.model.DescribeCopyJobRequest.ReadOnly = new Wrapper(impl)
}
