package zio.aws.backup.model
import java.time.Instant
import zio.aws.backup.model.primitives.{
  AccountId,
  Timestamp,
  ResourceType,
  MaxResults,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCopyJobsRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None,
    byResourceArn: Option[ARN] = None,
    byState: Option[zio.aws.backup.model.CopyJobState] = None,
    byCreatedBefore: Option[Timestamp] = None,
    byCreatedAfter: Option[Timestamp] = None,
    byResourceType: Option[ResourceType] = None,
    byDestinationVaultArn: Option[String] = None,
    byAccountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListCopyJobsRequest = {
    import ListCopyJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.byResourceArn)
      .optionallyWith(byState.map(value => value.unwrap))(_.byState)
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(
        byResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.byResourceType)
      .optionallyWith(
        byDestinationVaultArn.map(value => value: java.lang.String)
      )(_.byDestinationVaultArn)
      .optionallyWith(
        byAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.byAccountId)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListCopyJobsRequest.ReadOnly =
    zio.aws.backup.model.ListCopyJobsRequest.wrap(buildAwsValue())
}
object ListCopyJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListCopyJobsRequest =
      zio.aws.backup.model.ListCopyJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        byResourceArn.map(value => value),
        byState.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byResourceType.map(value => value),
        byDestinationVaultArn.map(value => value),
        byAccountId.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def byResourceArn: Option[ARN]
    def byState: Option[zio.aws.backup.model.CopyJobState]
    def byCreatedBefore: Option[Timestamp]
    def byCreatedAfter: Option[Timestamp]
    def byResourceType: Option[ResourceType]
    def byDestinationVaultArn: Option[String]
    def byAccountId: Option[AccountId]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("byResourceArn", byResourceArn)
    def getByState: ZIO[Any, AwsError, zio.aws.backup.model.CopyJobState] =
      AwsError.unwrapOptionField("byState", byState)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("byResourceType", byResourceType)
    def getByDestinationVaultArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("byDestinationVaultArn", byDestinationVaultArn)
    def getByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("byAccountId", byAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ) extends zio.aws.backup.model.ListCopyJobsRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byResourceArn: Option[ARN] = scala
      .Option(impl.byResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val byState: Option[zio.aws.backup.model.CopyJobState] = scala
      .Option(impl.byState())
      .map(value => zio.aws.backup.model.CopyJobState.wrap(value))
    override val byCreatedBefore: Option[Timestamp] = scala
      .Option(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Option[Timestamp] = scala
      .Option(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byResourceType: Option[ResourceType] = scala
      .Option(impl.byResourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val byDestinationVaultArn: Option[String] =
      scala.Option(impl.byDestinationVaultArn()).map(value => value: String)
    override val byAccountId: Option[AccountId] = scala
      .Option(impl.byAccountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ): zio.aws.backup.model.ListCopyJobsRequest.ReadOnly = new Wrapper(impl)
}
