package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Lifecycle(
    moveToColdStorageAfterDays: Option[Long] = None,
    deleteAfterDays: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.Lifecycle = {
    import Lifecycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.Lifecycle
      .builder()
      .optionallyWith(
        moveToColdStorageAfterDays.map(value => value: java.lang.Long)
      )(_.moveToColdStorageAfterDays)
      .optionallyWith(deleteAfterDays.map(value => value: java.lang.Long))(
        _.deleteAfterDays
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.Lifecycle.ReadOnly =
    zio.aws.backup.model.Lifecycle.wrap(buildAwsValue())
}
object Lifecycle {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.Lifecycle] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.Lifecycle =
      zio.aws.backup.model.Lifecycle(
        moveToColdStorageAfterDays.map(value => value),
        deleteAfterDays.map(value => value)
      )
    def moveToColdStorageAfterDays: Option[Long]
    def deleteAfterDays: Option[Long]
    def getMoveToColdStorageAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "moveToColdStorageAfterDays",
        moveToColdStorageAfterDays
      )
    def getDeleteAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deleteAfterDays", deleteAfterDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.Lifecycle
  ) extends zio.aws.backup.model.Lifecycle.ReadOnly {
    override val moveToColdStorageAfterDays: Option[Long] =
      scala.Option(impl.moveToColdStorageAfterDays()).map(value => value: Long)
    override val deleteAfterDays: Option[Long] =
      scala.Option(impl.deleteAfterDays()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.Lifecycle
  ): zio.aws.backup.model.Lifecycle.ReadOnly = new Wrapper(impl)
}
