package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ReportPlanDescription, ReportPlanName}
import scala.jdk.CollectionConverters._
final case class CreateReportPlanRequest(
    reportPlanName: ReportPlanName,
    reportPlanDescription: Option[ReportPlanDescription] = None,
    reportDeliveryChannel: zio.aws.backup.model.ReportDeliveryChannel,
    reportSetting: zio.aws.backup.model.ReportSetting,
    reportPlanTags: Option[Map[String, String]] = None,
    idempotencyToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateReportPlanRequest = {
    import CreateReportPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateReportPlanRequest
      .builder()
      .reportPlanName(ReportPlanName.unwrap(reportPlanName): java.lang.String)
      .optionallyWith(
        reportPlanDescription.map(value =>
          ReportPlanDescription.unwrap(value): java.lang.String
        )
      )(_.reportPlanDescription)
      .reportDeliveryChannel(reportDeliveryChannel.buildAwsValue())
      .reportSetting(reportSetting.buildAwsValue())
      .optionallyWith(
        reportPlanTags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.reportPlanTags)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateReportPlanRequest.ReadOnly =
    zio.aws.backup.model.CreateReportPlanRequest.wrap(buildAwsValue())
}
object CreateReportPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateReportPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateReportPlanRequest =
      zio.aws.backup.model.CreateReportPlanRequest(
        reportPlanName,
        reportPlanDescription.map(value => value),
        reportDeliveryChannel.asEditable,
        reportSetting.asEditable,
        reportPlanTags.map(value => value),
        idempotencyToken.map(value => value)
      )
    def reportPlanName: ReportPlanName
    def reportPlanDescription: Option[ReportPlanDescription]
    def reportDeliveryChannel
        : zio.aws.backup.model.ReportDeliveryChannel.ReadOnly
    def reportSetting: zio.aws.backup.model.ReportSetting.ReadOnly
    def reportPlanTags: Option[Map[String, String]]
    def idempotencyToken: Option[String]
    def getReportPlanName: ZIO[Any, Nothing, ReportPlanName] =
      ZIO.succeed(reportPlanName)
    def getReportPlanDescription: ZIO[Any, AwsError, ReportPlanDescription] =
      AwsError.unwrapOptionField("reportPlanDescription", reportPlanDescription)
    def getReportDeliveryChannel: ZIO[
      Any,
      Nothing,
      zio.aws.backup.model.ReportDeliveryChannel.ReadOnly
    ] = ZIO.succeed(reportDeliveryChannel)
    def getReportSetting
        : ZIO[Any, Nothing, zio.aws.backup.model.ReportSetting.ReadOnly] =
      ZIO.succeed(reportSetting)
    def getReportPlanTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("reportPlanTags", reportPlanTags)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateReportPlanRequest
  ) extends zio.aws.backup.model.CreateReportPlanRequest.ReadOnly {
    override val reportPlanName: ReportPlanName =
      zio.aws.backup.model.primitives.ReportPlanName(impl.reportPlanName())
    override val reportPlanDescription: Option[ReportPlanDescription] = scala
      .Option(impl.reportPlanDescription())
      .map(value =>
        zio.aws.backup.model.primitives.ReportPlanDescription(value)
      )
    override val reportDeliveryChannel
        : zio.aws.backup.model.ReportDeliveryChannel.ReadOnly =
      zio.aws.backup.model.ReportDeliveryChannel
        .wrap(impl.reportDeliveryChannel())
    override val reportSetting: zio.aws.backup.model.ReportSetting.ReadOnly =
      zio.aws.backup.model.ReportSetting.wrap(impl.reportSetting())
    override val reportPlanTags: Option[Map[String, String]] = scala
      .Option(impl.reportPlanTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateReportPlanRequest
  ): zio.aws.backup.model.CreateReportPlanRequest.ReadOnly = new Wrapper(impl)
}
