package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait RecoveryPointStatus {
  def unwrap: software.amazon.awssdk.services.backup.model.RecoveryPointStatus
}
object RecoveryPointStatus {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.RecoveryPointStatus
  ): zio.aws.backup.model.RecoveryPointStatus = value match {
    case software.amazon.awssdk.services.backup.model.RecoveryPointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.RecoveryPointStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.RecoveryPointStatus.PARTIAL =>
      val r = PARTIAL
      r
    case software.amazon.awssdk.services.backup.model.RecoveryPointStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.backup.model.RecoveryPointStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backup.model.RecoveryPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RecoveryPointStatus =
      software.amazon.awssdk.services.backup.model.RecoveryPointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED extends zio.aws.backup.model.RecoveryPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RecoveryPointStatus =
      software.amazon.awssdk.services.backup.model.RecoveryPointStatus.COMPLETED
  }
  case object PARTIAL extends zio.aws.backup.model.RecoveryPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RecoveryPointStatus =
      software.amazon.awssdk.services.backup.model.RecoveryPointStatus.PARTIAL
  }
  case object DELETING extends zio.aws.backup.model.RecoveryPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RecoveryPointStatus =
      software.amazon.awssdk.services.backup.model.RecoveryPointStatus.DELETING
  }
  case object EXPIRED extends zio.aws.backup.model.RecoveryPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RecoveryPointStatus =
      software.amazon.awssdk.services.backup.model.RecoveryPointStatus.EXPIRED
  }
}
