package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ControlName
import scala.jdk.CollectionConverters._
final case class FrameworkControl(
    controlName: ControlName,
    controlInputParameters: Option[
      Iterable[zio.aws.backup.model.ControlInputParameter]
    ] = None,
    controlScope: Option[zio.aws.backup.model.ControlScope] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.FrameworkControl = {
    import FrameworkControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.FrameworkControl
      .builder()
      .controlName(ControlName.unwrap(controlName): java.lang.String)
      .optionallyWith(
        controlInputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlInputParameters)
      .optionallyWith(controlScope.map(value => value.buildAwsValue()))(
        _.controlScope
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.FrameworkControl.ReadOnly =
    zio.aws.backup.model.FrameworkControl.wrap(buildAwsValue())
}
object FrameworkControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.FrameworkControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.FrameworkControl =
      zio.aws.backup.model.FrameworkControl(
        controlName,
        controlInputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        controlScope.map(value => value.asEditable)
      )
    def controlName: ControlName
    def controlInputParameters
        : Option[List[zio.aws.backup.model.ControlInputParameter.ReadOnly]]
    def controlScope: Option[zio.aws.backup.model.ControlScope.ReadOnly]
    def getControlName: ZIO[Any, Nothing, ControlName] =
      ZIO.succeed(controlName)
    def getControlInputParameters: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ControlInputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "controlInputParameters",
      controlInputParameters
    )
    def getControlScope
        : ZIO[Any, AwsError, zio.aws.backup.model.ControlScope.ReadOnly] =
      AwsError.unwrapOptionField("controlScope", controlScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.FrameworkControl
  ) extends zio.aws.backup.model.FrameworkControl.ReadOnly {
    override val controlName: ControlName =
      zio.aws.backup.model.primitives.ControlName(impl.controlName())
    override val controlInputParameters
        : Option[List[zio.aws.backup.model.ControlInputParameter.ReadOnly]] =
      scala
        .Option(impl.controlInputParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ControlInputParameter.wrap(item)
          }.toList
        )
    override val controlScope
        : Option[zio.aws.backup.model.ControlScope.ReadOnly] = scala
      .Option(impl.controlScope())
      .map(value => zio.aws.backup.model.ControlScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.FrameworkControl
  ): zio.aws.backup.model.FrameworkControl.ReadOnly = new Wrapper(impl)
}
