package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ParameterValue, ParameterName}
import scala.jdk.CollectionConverters._
final case class ControlInputParameter(
    parameterName: Option[ParameterName] = None,
    parameterValue: Option[ParameterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ControlInputParameter = {
    import ControlInputParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ControlInputParameter
      .builder()
      .optionallyWith(
        parameterName.map(value =>
          ParameterName.unwrap(value): java.lang.String
        )
      )(_.parameterName)
      .optionallyWith(
        parameterValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.parameterValue)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ControlInputParameter.ReadOnly =
    zio.aws.backup.model.ControlInputParameter.wrap(buildAwsValue())
}
object ControlInputParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ControlInputParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ControlInputParameter =
      zio.aws.backup.model.ControlInputParameter(
        parameterName.map(value => value),
        parameterValue.map(value => value)
      )
    def parameterName: Option[ParameterName]
    def parameterValue: Option[ParameterValue]
    def getParameterName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ControlInputParameter
  ) extends zio.aws.backup.model.ControlInputParameter.ReadOnly {
    override val parameterName: Option[ParameterName] = scala
      .Option(impl.parameterName())
      .map(value => zio.aws.backup.model.primitives.ParameterName(value))
    override val parameterValue: Option[ParameterValue] = scala
      .Option(impl.parameterValue())
      .map(value => zio.aws.backup.model.primitives.ParameterValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ControlInputParameter
  ): zio.aws.backup.model.ControlInputParameter.ReadOnly = new Wrapper(impl)
}
