package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ReportSetting(
    reportTemplate: String,
    frameworkArns: Option[Iterable[String]] = None,
    numberOfFrameworks: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportSetting = {
    import ReportSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportSetting
      .builder()
      .reportTemplate(reportTemplate: java.lang.String)
      .optionallyWith(
        frameworkArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.frameworkArns)
      .optionallyWith(
        numberOfFrameworks.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.numberOfFrameworks)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportSetting.ReadOnly =
    zio.aws.backup.model.ReportSetting.wrap(buildAwsValue())
}
object ReportSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ReportSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportSetting =
      zio.aws.backup.model.ReportSetting(
        reportTemplate,
        frameworkArns.map(value => value),
        numberOfFrameworks.map(value => value)
      )
    def reportTemplate: String
    def frameworkArns: Option[List[String]]
    def numberOfFrameworks: Option[Integer]
    def getReportTemplate: ZIO[Any, Nothing, String] =
      ZIO.succeed(reportTemplate)
    def getFrameworkArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("frameworkArns", frameworkArns)
    def getNumberOfFrameworks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfFrameworks", numberOfFrameworks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportSetting
  ) extends zio.aws.backup.model.ReportSetting.ReadOnly {
    override val reportTemplate: String = impl.reportTemplate(): String
    override val frameworkArns: Option[List[String]] = scala
      .Option(impl.frameworkArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val numberOfFrameworks: Option[Integer] = scala
      .Option(impl.numberOfFrameworks())
      .map(value => zio.aws.backup.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportSetting
  ): zio.aws.backup.model.ReportSetting.ReadOnly = new Wrapper(impl)
}
