package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeleteBackupPlanResponse(
    backupPlanId: Option[String] = None,
    backupPlanArn: Option[ARN] = None,
    deletionDate: Option[Timestamp] = None,
    versionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse = {
    import DeleteBackupPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
      .builder()
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(
        deletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly =
    zio.aws.backup.model.DeleteBackupPlanResponse.wrap(buildAwsValue())
}
object DeleteBackupPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupPlanResponse =
      zio.aws.backup.model.DeleteBackupPlanResponse(
        backupPlanId.map(value => value),
        backupPlanArn.map(value => value),
        deletionDate.map(value => value),
        versionId.map(value => value)
      )
    def backupPlanId: Option[String]
    def backupPlanArn: Option[ARN]
    def deletionDate: Option[Timestamp]
    def versionId: Option[String]
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getDeletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ) extends zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly {
    override val backupPlanId: Option[String] =
      scala.Option(impl.backupPlanId()).map(value => value: String)
    override val backupPlanArn: Option[ARN] = scala
      .Option(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val deletionDate: Option[Timestamp] = scala
      .Option(impl.deletionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val versionId: Option[String] =
      scala.Option(impl.versionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ): zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly = new Wrapper(impl)
}
