package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReportJobResponse(
    reportJob: Option[zio.aws.backup.model.ReportJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeReportJobResponse = {
    import DescribeReportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeReportJobResponse
      .builder()
      .optionallyWith(reportJob.map(value => value.buildAwsValue()))(
        _.reportJob
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeReportJobResponse.ReadOnly =
    zio.aws.backup.model.DescribeReportJobResponse.wrap(buildAwsValue())
}
object DescribeReportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeReportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeReportJobResponse =
      zio.aws.backup.model
        .DescribeReportJobResponse(reportJob.map(value => value.asEditable))
    def reportJob: Option[zio.aws.backup.model.ReportJob.ReadOnly]
    def getReportJob
        : ZIO[Any, AwsError, zio.aws.backup.model.ReportJob.ReadOnly] =
      AwsError.unwrapOptionField("reportJob", reportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportJobResponse
  ) extends zio.aws.backup.model.DescribeReportJobResponse.ReadOnly {
    override val reportJob: Option[zio.aws.backup.model.ReportJob.ReadOnly] =
      scala
        .Option(impl.reportJob())
        .map(value => zio.aws.backup.model.ReportJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportJobResponse
  ): zio.aws.backup.model.DescribeReportJobResponse.ReadOnly = new Wrapper(impl)
}
