package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{MetadataValue, MetadataKey, ARN}
import scala.jdk.CollectionConverters._
final case class GetRecoveryPointRestoreMetadataResponse(
    backupVaultArn: Option[ARN] = None,
    recoveryPointArn: Option[ARN] = None,
    restoreMetadata: Option[Map[MetadataKey, MetadataValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse = {
    import GetRecoveryPointRestoreMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
      .builder()
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        restoreMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.restoreMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly =
    zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse
      .wrap(buildAwsValue())
}
object GetRecoveryPointRestoreMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse =
      zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse(
        backupVaultArn.map(value => value),
        recoveryPointArn.map(value => value),
        restoreMetadata.map(value => value)
      )
    def backupVaultArn: Option[ARN]
    def recoveryPointArn: Option[ARN]
    def restoreMetadata: Option[Map[MetadataKey, MetadataValue]]
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getRestoreMetadata
        : ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("restoreMetadata", restoreMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ) extends zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly {
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val restoreMetadata: Option[Map[MetadataKey, MetadataValue]] =
      scala
        .Option(impl.restoreMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.MetadataKey(
                key
              ) -> zio.aws.backup.model.primitives.MetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ): zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
