package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class DeleteRecoveryPointRequest(
    backupVaultName: BackupVaultName,
    recoveryPointArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest = {
    import DeleteRecoveryPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteRecoveryPointRequest.ReadOnly =
    zio.aws.backup.model.DeleteRecoveryPointRequest.wrap(buildAwsValue())
}
object DeleteRecoveryPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteRecoveryPointRequest =
      zio.aws.backup.model
        .DeleteRecoveryPointRequest(backupVaultName, recoveryPointArn)
    def backupVaultName: BackupVaultName
    def recoveryPointArn: ARN
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest
  ) extends zio.aws.backup.model.DeleteRecoveryPointRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest
  ): zio.aws.backup.model.DeleteRecoveryPointRequest.ReadOnly = new Wrapper(
    impl
  )
}
