package zio.aws.backup.model
import java.time.Instant
import zio.aws.backup.model.primitives.{Timestamp, AccountId, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRestoreJobsRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None,
    byAccountId: Option[AccountId] = None,
    byCreatedBefore: Option[Timestamp] = None,
    byCreatedAfter: Option[Timestamp] = None,
    byStatus: Option[zio.aws.backup.model.RestoreJobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest = {
    import ListRestoreJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.byAccountId)
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(byStatus.map(value => value.unwrap))(_.byStatus)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly =
    zio.aws.backup.model.ListRestoreJobsRequest.wrap(buildAwsValue())
}
object ListRestoreJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRestoreJobsRequest =
      zio.aws.backup.model.ListRestoreJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        byAccountId.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byStatus.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def byAccountId: Option[AccountId]
    def byCreatedBefore: Option[Timestamp]
    def byCreatedAfter: Option[Timestamp]
    def byStatus: Option[zio.aws.backup.model.RestoreJobStatus]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("byAccountId", byAccountId)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByStatus: ZIO[Any, AwsError, zio.aws.backup.model.RestoreJobStatus] =
      AwsError.unwrapOptionField("byStatus", byStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ) extends zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byAccountId: Option[AccountId] = scala
      .Option(impl.byAccountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val byCreatedBefore: Option[Timestamp] = scala
      .Option(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Option[Timestamp] = scala
      .Option(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byStatus: Option[zio.aws.backup.model.RestoreJobStatus] = scala
      .Option(impl.byStatus())
      .map(value => zio.aws.backup.model.RestoreJobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ): zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly = new Wrapper(impl)
}
