package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class GetBackupVaultNotificationsResponse(
    backupVaultName: Option[BackupVaultName] = None,
    backupVaultArn: Option[ARN] = None,
    snsTopicArn: Option[ARN] = None,
    backupVaultEvents: Option[Iterable[zio.aws.backup.model.BackupVaultEvent]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse = {
    import GetBackupVaultNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        snsTopicArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        backupVaultEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.backupVaultEventsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly =
    zio.aws.backup.model.GetBackupVaultNotificationsResponse
      .wrap(buildAwsValue())
}
object GetBackupVaultNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupVaultNotificationsResponse =
      zio.aws.backup.model.GetBackupVaultNotificationsResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        snsTopicArn.map(value => value),
        backupVaultEvents.map(value => value)
      )
    def backupVaultName: Option[BackupVaultName]
    def backupVaultArn: Option[ARN]
    def snsTopicArn: Option[ARN]
    def backupVaultEvents: Option[List[zio.aws.backup.model.BackupVaultEvent]]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getSnsTopicArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getBackupVaultEvents
        : ZIO[Any, AwsError, List[zio.aws.backup.model.BackupVaultEvent]] =
      AwsError.unwrapOptionField("backupVaultEvents", backupVaultEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ) extends zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly {
    override val backupVaultName: Option[BackupVaultName] = scala
      .Option(impl.backupVaultName())
      .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val snsTopicArn: Option[ARN] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupVaultEvents
        : Option[List[zio.aws.backup.model.BackupVaultEvent]] = scala
      .Option(impl.backupVaultEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.BackupVaultEvent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ): zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
