package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetBackupSelectionResponse(
    backupSelection: Option[zio.aws.backup.model.BackupSelection] = None,
    selectionId: Option[String] = None,
    backupPlanId: Option[String] = None,
    creationDate: Option[Timestamp] = None,
    creatorRequestId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse = {
    import GetBackupSelectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
      .builder()
      .optionallyWith(backupSelection.map(value => value.buildAwsValue()))(
        _.backupSelection
      )
      .optionallyWith(selectionId.map(value => value: java.lang.String))(
        _.selectionId
      )
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly =
    zio.aws.backup.model.GetBackupSelectionResponse.wrap(buildAwsValue())
}
object GetBackupSelectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupSelectionResponse =
      zio.aws.backup.model.GetBackupSelectionResponse(
        backupSelection.map(value => value.asEditable),
        selectionId.map(value => value),
        backupPlanId.map(value => value),
        creationDate.map(value => value),
        creatorRequestId.map(value => value)
      )
    def backupSelection: Option[zio.aws.backup.model.BackupSelection.ReadOnly]
    def selectionId: Option[String]
    def backupPlanId: Option[String]
    def creationDate: Option[Timestamp]
    def creatorRequestId: Option[String]
    def getBackupSelection
        : ZIO[Any, AwsError, zio.aws.backup.model.BackupSelection.ReadOnly] =
      AwsError.unwrapOptionField("backupSelection", backupSelection)
    def getSelectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionId", selectionId)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ) extends zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly {
    override val backupSelection
        : Option[zio.aws.backup.model.BackupSelection.ReadOnly] = scala
      .Option(impl.backupSelection())
      .map(value => zio.aws.backup.model.BackupSelection.wrap(value))
    override val selectionId: Option[String] =
      scala.Option(impl.selectionId()).map(value => value: String)
    override val backupPlanId: Option[String] =
      scala.Option(impl.backupPlanId()).map(value => value: String)
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val creatorRequestId: Option[String] =
      scala.Option(impl.creatorRequestId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ): zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
