package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN, FrameworkName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateFrameworkResponse(
    frameworkName: Option[FrameworkName] = None,
    frameworkArn: Option[ARN] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse = {
    import UpdateFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly =
    zio.aws.backup.model.UpdateFrameworkResponse.wrap(buildAwsValue())
}
object UpdateFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateFrameworkResponse =
      zio.aws.backup.model.UpdateFrameworkResponse(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        creationTime.map(value => value)
      )
    def frameworkName: Option[FrameworkName]
    def frameworkArn: Option[ARN]
    def creationTime: Option[Timestamp]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ) extends zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly {
    override val frameworkName: Option[FrameworkName] = scala
      .Option(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Option[ARN] = scala
      .Option(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ): zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly = new Wrapper(impl)
}
