package zio.aws.backup.model
import java.time.Instant
import zio.aws.backup.model.primitives.{MaxResults, Timestamp, ReportPlanName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReportJobsRequest(
    byReportPlanName: Option[ReportPlanName] = None,
    byCreationBefore: Option[Timestamp] = None,
    byCreationAfter: Option[Timestamp] = None,
    byStatus: Option[String] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListReportJobsRequest = {
    import ListReportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListReportJobsRequest
      .builder()
      .optionallyWith(
        byReportPlanName.map(value =>
          ReportPlanName.unwrap(value): java.lang.String
        )
      )(_.byReportPlanName)
      .optionallyWith(
        byCreationBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreationBefore)
      .optionallyWith(
        byCreationAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreationAfter)
      .optionallyWith(byStatus.map(value => value: java.lang.String))(
        _.byStatus
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListReportJobsRequest.ReadOnly =
    zio.aws.backup.model.ListReportJobsRequest.wrap(buildAwsValue())
}
object ListReportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListReportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListReportJobsRequest =
      zio.aws.backup.model.ListReportJobsRequest(
        byReportPlanName.map(value => value),
        byCreationBefore.map(value => value),
        byCreationAfter.map(value => value),
        byStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def byReportPlanName: Option[ReportPlanName]
    def byCreationBefore: Option[Timestamp]
    def byCreationAfter: Option[Timestamp]
    def byStatus: Option[String]
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def getByReportPlanName: ZIO[Any, AwsError, ReportPlanName] =
      AwsError.unwrapOptionField("byReportPlanName", byReportPlanName)
    def getByCreationBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreationBefore", byCreationBefore)
    def getByCreationAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreationAfter", byCreationAfter)
    def getByStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("byStatus", byStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListReportJobsRequest
  ) extends zio.aws.backup.model.ListReportJobsRequest.ReadOnly {
    override val byReportPlanName: Option[ReportPlanName] = scala
      .Option(impl.byReportPlanName())
      .map(value => zio.aws.backup.model.primitives.ReportPlanName(value))
    override val byCreationBefore: Option[Timestamp] = scala
      .Option(impl.byCreationBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreationAfter: Option[Timestamp] = scala
      .Option(impl.byCreationAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byStatus: Option[String] =
      scala.Option(impl.byStatus()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListReportJobsRequest
  ): zio.aws.backup.model.ListReportJobsRequest.ReadOnly = new Wrapper(impl)
}
