package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBackupJobsResponse(
    backupJobs: Option[Iterable[zio.aws.backup.model.BackupJob]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupJobsResponse = {
    import ListBackupJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
      .builder()
      .optionallyWith(
        backupJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupJobsResponse.ReadOnly =
    zio.aws.backup.model.ListBackupJobsResponse.wrap(buildAwsValue())
}
object ListBackupJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupJobsResponse =
      zio.aws.backup.model.ListBackupJobsResponse(
        backupJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backupJobs: Option[List[zio.aws.backup.model.BackupJob.ReadOnly]]
    def nextToken: Option[String]
    def getBackupJobs
        : ZIO[Any, AwsError, List[zio.aws.backup.model.BackupJob.ReadOnly]] =
      AwsError.unwrapOptionField("backupJobs", backupJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ) extends zio.aws.backup.model.ListBackupJobsResponse.ReadOnly {
    override val backupJobs
        : Option[List[zio.aws.backup.model.BackupJob.ReadOnly]] = scala
      .Option(impl.backupJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.BackupJob.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ): zio.aws.backup.model.ListBackupJobsResponse.ReadOnly = new Wrapper(impl)
}
