package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.ReportJobId
import scala.jdk.CollectionConverters._
final case class DescribeReportJobRequest(reportJobId: ReportJobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeReportJobRequest = {
    import DescribeReportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeReportJobRequest
      .builder()
      .reportJobId(ReportJobId.unwrap(reportJobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeReportJobRequest.ReadOnly =
    zio.aws.backup.model.DescribeReportJobRequest.wrap(buildAwsValue())
}
object DescribeReportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeReportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeReportJobRequest =
      zio.aws.backup.model.DescribeReportJobRequest(reportJobId)
    def reportJobId: ReportJobId
    def getReportJobId: ZIO[Any, Nothing, ReportJobId] =
      ZIO.succeed(reportJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportJobRequest
  ) extends zio.aws.backup.model.DescribeReportJobRequest.ReadOnly {
    override val reportJobId: ReportJobId =
      zio.aws.backup.model.primitives.ReportJobId(impl.reportJobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportJobRequest
  ): zio.aws.backup.model.DescribeReportJobRequest.ReadOnly = new Wrapper(impl)
}
