package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.RestoreJobId
import scala.jdk.CollectionConverters._
final case class StartRestoreJobResponse(
    restoreJobId: Option[RestoreJobId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartRestoreJobResponse = {
    import StartRestoreJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartRestoreJobResponse
      .builder()
      .optionallyWith(
        restoreJobId.map(value => RestoreJobId.unwrap(value): java.lang.String)
      )(_.restoreJobId)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartRestoreJobResponse.ReadOnly =
    zio.aws.backup.model.StartRestoreJobResponse.wrap(buildAwsValue())
}
object StartRestoreJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartRestoreJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartRestoreJobResponse =
      zio.aws.backup.model
        .StartRestoreJobResponse(restoreJobId.map(value => value))
    def restoreJobId: Option[RestoreJobId]
    def getRestoreJobId: ZIO[Any, AwsError, RestoreJobId] =
      AwsError.unwrapOptionField("restoreJobId", restoreJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobResponse
  ) extends zio.aws.backup.model.StartRestoreJobResponse.ReadOnly {
    override val restoreJobId: Option[RestoreJobId] = scala
      .Option(impl.restoreJobId())
      .map(value => zio.aws.backup.model.primitives.RestoreJobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobResponse
  ): zio.aws.backup.model.StartRestoreJobResponse.ReadOnly = new Wrapper(impl)
}
