package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  FrameworkName,
  Timestamp,
  FrameworkDescription,
  Integer,
  ARN
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Framework(
    frameworkName: Option[FrameworkName] = None,
    frameworkArn: Option[ARN] = None,
    frameworkDescription: Option[FrameworkDescription] = None,
    numberOfControls: Option[Integer] = None,
    creationTime: Option[Timestamp] = None,
    deploymentStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.Framework = {
    import Framework.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.Framework
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(
        numberOfControls.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numberOfControls)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(deploymentStatus.map(value => value: java.lang.String))(
        _.deploymentStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.Framework.ReadOnly =
    zio.aws.backup.model.Framework.wrap(buildAwsValue())
}
object Framework {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.Framework] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.Framework =
      zio.aws.backup.model.Framework(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        frameworkDescription.map(value => value),
        numberOfControls.map(value => value),
        creationTime.map(value => value),
        deploymentStatus.map(value => value)
      )
    def frameworkName: Option[FrameworkName]
    def frameworkArn: Option[ARN]
    def frameworkDescription: Option[FrameworkDescription]
    def numberOfControls: Option[Integer]
    def creationTime: Option[Timestamp]
    def deploymentStatus: Option[String]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getNumberOfControls: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfControls", numberOfControls)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeploymentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.Framework
  ) extends zio.aws.backup.model.Framework.ReadOnly {
    override val frameworkName: Option[FrameworkName] = scala
      .Option(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Option[ARN] = scala
      .Option(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val frameworkDescription: Option[FrameworkDescription] = scala
      .Option(impl.frameworkDescription())
      .map(value => zio.aws.backup.model.primitives.FrameworkDescription(value))
    override val numberOfControls: Option[Integer] = scala
      .Option(impl.numberOfControls())
      .map(value => zio.aws.backup.model.primitives.Integer(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deploymentStatus: Option[String] =
      scala.Option(impl.deploymentStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.Framework
  ): zio.aws.backup.model.Framework.ReadOnly = new Wrapper(impl)
}
