package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  BackupOptionValue,
  BackupOptionKey,
  ResourceType
}
import scala.jdk.CollectionConverters._
final case class AdvancedBackupSetting(
    resourceType: Option[ResourceType] = None,
    backupOptions: Option[Map[BackupOptionKey, BackupOptionValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.AdvancedBackupSetting = {
    import AdvancedBackupSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.AdvancedBackupSetting
      .builder()
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        backupOptions.map(value =>
          value
            .map({ case (key, value) =>
              (BackupOptionKey
                .unwrap(key): java.lang.String) -> (BackupOptionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupOptions)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.AdvancedBackupSetting.ReadOnly =
    zio.aws.backup.model.AdvancedBackupSetting.wrap(buildAwsValue())
}
object AdvancedBackupSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.AdvancedBackupSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.AdvancedBackupSetting =
      zio.aws.backup.model.AdvancedBackupSetting(
        resourceType.map(value => value),
        backupOptions.map(value => value)
      )
    def resourceType: Option[ResourceType]
    def backupOptions: Option[Map[BackupOptionKey, BackupOptionValue]]
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getBackupOptions
        : ZIO[Any, AwsError, Map[BackupOptionKey, BackupOptionValue]] =
      AwsError.unwrapOptionField("backupOptions", backupOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.AdvancedBackupSetting
  ) extends zio.aws.backup.model.AdvancedBackupSetting.ReadOnly {
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val backupOptions
        : Option[Map[BackupOptionKey, BackupOptionValue]] = scala
      .Option(impl.backupOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives.BackupOptionKey(
              key
            ) -> zio.aws.backup.model.primitives.BackupOptionValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.AdvancedBackupSetting
  ): zio.aws.backup.model.AdvancedBackupSetting.ReadOnly = new Wrapper(impl)
}
