package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ReportPlanName
import scala.jdk.CollectionConverters._
final case class StartReportJobRequest(
    reportPlanName: ReportPlanName,
    idempotencyToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartReportJobRequest = {
    import StartReportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartReportJobRequest
      .builder()
      .reportPlanName(ReportPlanName.unwrap(reportPlanName): java.lang.String)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartReportJobRequest.ReadOnly =
    zio.aws.backup.model.StartReportJobRequest.wrap(buildAwsValue())
}
object StartReportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartReportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartReportJobRequest =
      zio.aws.backup.model.StartReportJobRequest(
        reportPlanName,
        idempotencyToken.map(value => value)
      )
    def reportPlanName: ReportPlanName
    def idempotencyToken: Option[String]
    def getReportPlanName: ZIO[Any, Nothing, ReportPlanName] =
      ZIO.succeed(reportPlanName)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartReportJobRequest
  ) extends zio.aws.backup.model.StartReportJobRequest.ReadOnly {
    override val reportPlanName: ReportPlanName =
      zio.aws.backup.model.primitives.ReportPlanName(impl.reportPlanName())
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartReportJobRequest
  ): zio.aws.backup.model.StartReportJobRequest.ReadOnly = new Wrapper(impl)
}
