package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByResourceResponse(
    nextToken: Option[String] = None,
    recoveryPoints: Option[
      Iterable[zio.aws.backup.model.RecoveryPointByResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse = {
    import ListRecoveryPointsByResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        recoveryPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recoveryPoints)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByResourceResponse
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRecoveryPointsByResourceResponse =
      zio.aws.backup.model.ListRecoveryPointsByResourceResponse(
        nextToken.map(value => value),
        recoveryPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def recoveryPoints
        : Option[List[zio.aws.backup.model.RecoveryPointByResource.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecoveryPoints: ZIO[Any, AwsError, List[
      zio.aws.backup.model.RecoveryPointByResource.ReadOnly
    ]] = AwsError.unwrapOptionField("recoveryPoints", recoveryPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse
  ) extends zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val recoveryPoints
        : Option[List[zio.aws.backup.model.RecoveryPointByResource.ReadOnly]] =
      scala
        .Option(impl.recoveryPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.RecoveryPointByResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse
  ): zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly =
    new Wrapper(impl)
}
