package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN, ReportPlanName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateReportPlanResponse(
    reportPlanName: Option[ReportPlanName] = None,
    reportPlanArn: Option[ARN] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateReportPlanResponse = {
    import CreateReportPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateReportPlanResponse
      .builder()
      .optionallyWith(
        reportPlanName.map(value =>
          ReportPlanName.unwrap(value): java.lang.String
        )
      )(_.reportPlanName)
      .optionallyWith(
        reportPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.reportPlanArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateReportPlanResponse.ReadOnly =
    zio.aws.backup.model.CreateReportPlanResponse.wrap(buildAwsValue())
}
object CreateReportPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateReportPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateReportPlanResponse =
      zio.aws.backup.model.CreateReportPlanResponse(
        reportPlanName.map(value => value),
        reportPlanArn.map(value => value),
        creationTime.map(value => value)
      )
    def reportPlanName: Option[ReportPlanName]
    def reportPlanArn: Option[ARN]
    def creationTime: Option[Timestamp]
    def getReportPlanName: ZIO[Any, AwsError, ReportPlanName] =
      AwsError.unwrapOptionField("reportPlanName", reportPlanName)
    def getReportPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("reportPlanArn", reportPlanArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateReportPlanResponse
  ) extends zio.aws.backup.model.CreateReportPlanResponse.ReadOnly {
    override val reportPlanName: Option[ReportPlanName] = scala
      .Option(impl.reportPlanName())
      .map(value => zio.aws.backup.model.primitives.ReportPlanName(value))
    override val reportPlanArn: Option[ARN] = scala
      .Option(impl.reportPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateReportPlanResponse
  ): zio.aws.backup.model.CreateReportPlanResponse.ReadOnly = new Wrapper(impl)
}
