package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  ResourceType,
  ARN
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CopyJob(
    accountId: Option[AccountId] = None,
    copyJobId: Option[String] = None,
    sourceBackupVaultArn: Option[ARN] = None,
    sourceRecoveryPointArn: Option[ARN] = None,
    destinationBackupVaultArn: Option[ARN] = None,
    destinationRecoveryPointArn: Option[ARN] = None,
    resourceArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None,
    completionDate: Option[Timestamp] = None,
    state: Option[zio.aws.backup.model.CopyJobState] = None,
    statusMessage: Option[String] = None,
    backupSizeInBytes: Option[Long] = None,
    iamRoleArn: Option[IAMRoleArn] = None,
    createdBy: Option[zio.aws.backup.model.RecoveryPointCreator] = None,
    resourceType: Option[ResourceType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.backup.model.CopyJob = {
    import CopyJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CopyJob
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(copyJobId.map(value => value: java.lang.String))(
        _.copyJobId
      )
      .optionallyWith(
        sourceBackupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceBackupVaultArn)
      .optionallyWith(
        sourceRecoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceRecoveryPointArn)
      .optionallyWith(
        destinationBackupVaultArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.destinationBackupVaultArn)
      .optionallyWith(
        destinationRecoveryPointArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.destinationRecoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CopyJob.ReadOnly =
    zio.aws.backup.model.CopyJob.wrap(buildAwsValue())
}
object CopyJob {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.CopyJob] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CopyJob = zio.aws.backup.model.CopyJob(
      accountId.map(value => value),
      copyJobId.map(value => value),
      sourceBackupVaultArn.map(value => value),
      sourceRecoveryPointArn.map(value => value),
      destinationBackupVaultArn.map(value => value),
      destinationRecoveryPointArn.map(value => value),
      resourceArn.map(value => value),
      creationDate.map(value => value),
      completionDate.map(value => value),
      state.map(value => value),
      statusMessage.map(value => value),
      backupSizeInBytes.map(value => value),
      iamRoleArn.map(value => value),
      createdBy.map(value => value.asEditable),
      resourceType.map(value => value)
    )
    def accountId: Option[AccountId]
    def copyJobId: Option[String]
    def sourceBackupVaultArn: Option[ARN]
    def sourceRecoveryPointArn: Option[ARN]
    def destinationBackupVaultArn: Option[ARN]
    def destinationRecoveryPointArn: Option[ARN]
    def resourceArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def completionDate: Option[Timestamp]
    def state: Option[zio.aws.backup.model.CopyJobState]
    def statusMessage: Option[String]
    def backupSizeInBytes: Option[Long]
    def iamRoleArn: Option[IAMRoleArn]
    def createdBy: Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def resourceType: Option[ResourceType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCopyJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("copyJobId", copyJobId)
    def getSourceBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("sourceBackupVaultArn", sourceBackupVaultArn)
    def getSourceRecoveryPointArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("sourceRecoveryPointArn", sourceRecoveryPointArn)
    def getDestinationBackupVaultArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("destinationBackupVaultArn", destinationBackupVaultArn)
    def getDestinationRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField(
        "destinationRecoveryPointArn",
        destinationRecoveryPointArn
      )
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getState: ZIO[Any, AwsError, zio.aws.backup.model.CopyJobState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CopyJob
  ) extends zio.aws.backup.model.CopyJob.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val copyJobId: Option[String] =
      scala.Option(impl.copyJobId()).map(value => value: String)
    override val sourceBackupVaultArn: Option[ARN] = scala
      .Option(impl.sourceBackupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val sourceRecoveryPointArn: Option[ARN] = scala
      .Option(impl.sourceRecoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val destinationBackupVaultArn: Option[ARN] = scala
      .Option(impl.destinationBackupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val destinationRecoveryPointArn: Option[ARN] = scala
      .Option(impl.destinationRecoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Option[ARN] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Option[Timestamp] = scala
      .Option(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val state: Option[zio.aws.backup.model.CopyJobState] = scala
      .Option(impl.state())
      .map(value => zio.aws.backup.model.CopyJobState.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val backupSizeInBytes: Option[Long] =
      scala.Option(impl.backupSizeInBytes()).map(value => value: Long)
    override val iamRoleArn: Option[IAMRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val createdBy
        : Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CopyJob
  ): zio.aws.backup.model.CopyJob.ReadOnly = new Wrapper(impl)
}
