package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  ResourceType,
  MetadataValue,
  MetadataKey,
  ARN
}
import scala.jdk.CollectionConverters._
final case class StartRestoreJobRequest(
    recoveryPointArn: ARN,
    metadata: Map[MetadataKey, MetadataValue],
    iamRoleArn: IAMRoleArn,
    idempotencyToken: Option[String] = None,
    resourceType: Option[ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartRestoreJobRequest = {
    import StartRestoreJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
      .builder()
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .metadata(
        metadata
          .map({ case (key, value) =>
            (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .iamRoleArn(IAMRoleArn.unwrap(iamRoleArn): java.lang.String)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartRestoreJobRequest.ReadOnly =
    zio.aws.backup.model.StartRestoreJobRequest.wrap(buildAwsValue())
}
object StartRestoreJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartRestoreJobRequest =
      zio.aws.backup.model.StartRestoreJobRequest(
        recoveryPointArn,
        metadata,
        iamRoleArn,
        idempotencyToken.map(value => value),
        resourceType.map(value => value)
      )
    def recoveryPointArn: ARN
    def metadata: Map[MetadataKey, MetadataValue]
    def iamRoleArn: IAMRoleArn
    def idempotencyToken: Option[String]
    def resourceType: Option[ResourceType]
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
    def getMetadata: ZIO[Any, Nothing, Map[MetadataKey, MetadataValue]] =
      ZIO.succeed(metadata)
    def getIamRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(iamRoleArn)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ) extends zio.aws.backup.model.StartRestoreJobRequest.ReadOnly {
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
    override val metadata: Map[MetadataKey, MetadataValue] = impl
      .metadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.backup.model.primitives.MetadataKey(
          key
        ) -> zio.aws.backup.model.primitives.MetadataValue(value)
      })
      .toMap
    override val iamRoleArn: IAMRoleArn =
      zio.aws.backup.model.primitives.IAMRoleArn(impl.iamRoleArn())
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ): zio.aws.backup.model.StartRestoreJobRequest.ReadOnly = new Wrapper(impl)
}
