package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  Timestamp,
  BackupVaultName,
  ResourceType,
  ARN
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RecoveryPointByBackupVault(
    recoveryPointArn: Option[ARN] = None,
    backupVaultName: Option[BackupVaultName] = None,
    backupVaultArn: Option[ARN] = None,
    sourceBackupVaultArn: Option[ARN] = None,
    resourceArn: Option[ARN] = None,
    resourceType: Option[ResourceType] = None,
    createdBy: Option[zio.aws.backup.model.RecoveryPointCreator] = None,
    iamRoleArn: Option[IAMRoleArn] = None,
    status: Option[zio.aws.backup.model.RecoveryPointStatus] = None,
    statusMessage: Option[String] = None,
    creationDate: Option[Timestamp] = None,
    completionDate: Option[Timestamp] = None,
    backupSizeInBytes: Option[Long] = None,
    calculatedLifecycle: Option[zio.aws.backup.model.CalculatedLifecycle] =
      None,
    lifecycle: Option[zio.aws.backup.model.Lifecycle] = None,
    encryptionKeyArn: Option[ARN] = None,
    isEncrypted: Option[Boolean] = None,
    lastRestoreTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault = {
    import RecoveryPointByBackupVault.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
      .builder()
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        sourceBackupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceBackupVaultArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(calculatedLifecycle.map(value => value.buildAwsValue()))(
        _.calculatedLifecycle
      )
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(
        _.isEncrypted
      )
      .optionallyWith(
        lastRestoreTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastRestoreTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly =
    zio.aws.backup.model.RecoveryPointByBackupVault.wrap(buildAwsValue())
}
object RecoveryPointByBackupVault {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointByBackupVault =
      zio.aws.backup.model.RecoveryPointByBackupVault(
        recoveryPointArn.map(value => value),
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        sourceBackupVaultArn.map(value => value),
        resourceArn.map(value => value),
        resourceType.map(value => value),
        createdBy.map(value => value.asEditable),
        iamRoleArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        backupSizeInBytes.map(value => value),
        calculatedLifecycle.map(value => value.asEditable),
        lifecycle.map(value => value.asEditable),
        encryptionKeyArn.map(value => value),
        isEncrypted.map(value => value),
        lastRestoreTime.map(value => value)
      )
    def recoveryPointArn: Option[ARN]
    def backupVaultName: Option[BackupVaultName]
    def backupVaultArn: Option[ARN]
    def sourceBackupVaultArn: Option[ARN]
    def resourceArn: Option[ARN]
    def resourceType: Option[ResourceType]
    def createdBy: Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def iamRoleArn: Option[IAMRoleArn]
    def status: Option[zio.aws.backup.model.RecoveryPointStatus]
    def statusMessage: Option[String]
    def creationDate: Option[Timestamp]
    def completionDate: Option[Timestamp]
    def backupSizeInBytes: Option[Long]
    def calculatedLifecycle
        : Option[zio.aws.backup.model.CalculatedLifecycle.ReadOnly]
    def lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly]
    def encryptionKeyArn: Option[ARN]
    def isEncrypted: Option[Boolean]
    def lastRestoreTime: Option[Timestamp]
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getSourceBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("sourceBackupVaultArn", sourceBackupVaultArn)
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.backup.model.RecoveryPointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getCalculatedLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.CalculatedLifecycle.ReadOnly
    ] = AwsError.unwrapOptionField("calculatedLifecycle", calculatedLifecycle)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getIsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEncrypted", isEncrypted)
    def getLastRestoreTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastRestoreTime", lastRestoreTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ) extends zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly {
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupVaultName: Option[BackupVaultName] = scala
      .Option(impl.backupVaultName())
      .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val sourceBackupVaultArn: Option[ARN] = scala
      .Option(impl.sourceBackupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Option[ARN] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val createdBy
        : Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val iamRoleArn: Option[IAMRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val status: Option[zio.aws.backup.model.RecoveryPointStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.backup.model.RecoveryPointStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Option[Timestamp] = scala
      .Option(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val backupSizeInBytes: Option[Long] =
      scala.Option(impl.backupSizeInBytes()).map(value => value: Long)
    override val calculatedLifecycle
        : Option[zio.aws.backup.model.CalculatedLifecycle.ReadOnly] = scala
      .Option(impl.calculatedLifecycle())
      .map(value => zio.aws.backup.model.CalculatedLifecycle.wrap(value))
    override val lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val encryptionKeyArn: Option[ARN] = scala
      .Option(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val isEncrypted: Option[Boolean] =
      scala.Option(impl.isEncrypted()).map(value => value: Boolean)
    override val lastRestoreTime: Option[Timestamp] = scala
      .Option(impl.lastRestoreTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ): zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly = new Wrapper(
    impl
  )
}
