package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{IAMPolicy, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class PutBackupVaultAccessPolicyRequest(
    backupVaultName: BackupVaultName,
    policy: Option[IAMPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest = {
    import PutBackupVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(
        policy.map(value => IAMPolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.PutBackupVaultAccessPolicyRequest.ReadOnly =
    zio.aws.backup.model.PutBackupVaultAccessPolicyRequest.wrap(buildAwsValue())
}
object PutBackupVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.PutBackupVaultAccessPolicyRequest =
      zio.aws.backup.model.PutBackupVaultAccessPolicyRequest(
        backupVaultName,
        policy.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def policy: Option[IAMPolicy]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getPolicy: ZIO[Any, AwsError, IAMPolicy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest
  ) extends zio.aws.backup.model.PutBackupVaultAccessPolicyRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val policy: Option[IAMPolicy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.backup.model.primitives.IAMPolicy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest
  ): zio.aws.backup.model.PutBackupVaultAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
