package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  ResourceType,
  ARN
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeRestoreJobResponse(
    accountId: Option[AccountId] = None,
    restoreJobId: Option[String] = None,
    recoveryPointArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None,
    completionDate: Option[Timestamp] = None,
    status: Option[zio.aws.backup.model.RestoreJobStatus] = None,
    statusMessage: Option[String] = None,
    percentDone: Option[String] = None,
    backupSizeInBytes: Option[Long] = None,
    iamRoleArn: Option[IAMRoleArn] = None,
    expectedCompletionTimeMinutes: Option[Long] = None,
    createdResourceArn: Option[ARN] = None,
    resourceType: Option[ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse = {
    import DescribeRestoreJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(restoreJobId.map(value => value: java.lang.String))(
        _.restoreJobId
      )
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(percentDone.map(value => value: java.lang.String))(
        _.percentDone
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        expectedCompletionTimeMinutes.map(value => value: java.lang.Long)
      )(_.expectedCompletionTimeMinutes)
      .optionallyWith(
        createdResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.createdResourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly =
    zio.aws.backup.model.DescribeRestoreJobResponse.wrap(buildAwsValue())
}
object DescribeRestoreJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeRestoreJobResponse =
      zio.aws.backup.model.DescribeRestoreJobResponse(
        accountId.map(value => value),
        restoreJobId.map(value => value),
        recoveryPointArn.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        percentDone.map(value => value),
        backupSizeInBytes.map(value => value),
        iamRoleArn.map(value => value),
        expectedCompletionTimeMinutes.map(value => value),
        createdResourceArn.map(value => value),
        resourceType.map(value => value)
      )
    def accountId: Option[AccountId]
    def restoreJobId: Option[String]
    def recoveryPointArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def completionDate: Option[Timestamp]
    def status: Option[zio.aws.backup.model.RestoreJobStatus]
    def statusMessage: Option[String]
    def percentDone: Option[String]
    def backupSizeInBytes: Option[Long]
    def iamRoleArn: Option[IAMRoleArn]
    def expectedCompletionTimeMinutes: Option[Long]
    def createdResourceArn: Option[ARN]
    def resourceType: Option[ResourceType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRestoreJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreJobId", restoreJobId)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.backup.model.RestoreJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPercentDone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentDone", percentDone)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getExpectedCompletionTimeMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "expectedCompletionTimeMinutes",
        expectedCompletionTimeMinutes
      )
    def getCreatedResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("createdResourceArn", createdResourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse
  ) extends zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val restoreJobId: Option[String] =
      scala.Option(impl.restoreJobId()).map(value => value: String)
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Option[Timestamp] = scala
      .Option(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.backup.model.RestoreJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.backup.model.RestoreJobStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val percentDone: Option[String] =
      scala.Option(impl.percentDone()).map(value => value: String)
    override val backupSizeInBytes: Option[Long] =
      scala.Option(impl.backupSizeInBytes()).map(value => value: Long)
    override val iamRoleArn: Option[IAMRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val expectedCompletionTimeMinutes: Option[Long] = scala
      .Option(impl.expectedCompletionTimeMinutes())
      .map(value => value: Long)
    override val createdResourceArn: Option[ARN] = scala
      .Option(impl.createdResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse
  ): zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
