package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait PredictiveScalingMaxCapacityBehavior {
  def unwrap: software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
}
object PredictiveScalingMaxCapacityBehavior {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
  ): zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior =
    value match {
      case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_FORECAST_CAPACITY_TO_MAX_CAPACITY =>
        val r = SetForecastCapacityToMaxCapacity
        r
      case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_MAX_CAPACITY_TO_FORECAST_CAPACITY =>
        val r = SetMaxCapacityToForecastCapacity
        r
      case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_MAX_CAPACITY_ABOVE_FORECAST_CAPACITY =>
        val r = SetMaxCapacityAboveForecastCapacity
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object SetForecastCapacityToMaxCapacity
      extends zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_FORECAST_CAPACITY_TO_MAX_CAPACITY
  }
  case object SetMaxCapacityToForecastCapacity
      extends zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_MAX_CAPACITY_TO_FORECAST_CAPACITY
  }
  case object SetMaxCapacityAboveForecastCapacity
      extends zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior.SET_MAX_CAPACITY_ABOVE_FORECAST_CAPACITY
  }
}
