package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ScalingPlanStatusCode {
  def unwrap: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode
}
object ScalingPlanStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode
  ): zio.aws.autoscalingplans.model.ScalingPlanStatusCode = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.ACTIVE_WITH_PROBLEMS =>
      val r = ActiveWithProblems
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.CREATION_IN_PROGRESS =>
      val r = CreationInProgress
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.CREATION_FAILED =>
      val r = CreationFailed
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.DELETION_IN_PROGRESS =>
      val r = DeletionInProgress
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.DELETION_FAILED =>
      val r = DeletionFailed
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UPDATE_IN_PROGRESS =>
      val r = UpdateInProgress
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UPDATE_FAILED =>
      val r = UpdateFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Active
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.ACTIVE
  }
  case object ActiveWithProblems
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.ACTIVE_WITH_PROBLEMS
  }
  case object CreationInProgress
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.CREATION_IN_PROGRESS
  }
  case object CreationFailed
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.CREATION_FAILED
  }
  case object DeletionInProgress
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.DELETION_IN_PROGRESS
  }
  case object DeletionFailed
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.DELETION_FAILED
  }
  case object UpdateInProgress
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UPDATE_IN_PROGRESS
  }
  case object UpdateFailed
      extends zio.aws.autoscalingplans.model.ScalingPlanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode.UPDATE_FAILED
  }
}
