package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.autoscalingplans.model.primitives.{
  TimestampType,
  XmlString,
  ScalingPlanVersion,
  ScalingPlanName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetScalingPlanResourceForecastDataRequest(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion,
    serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace,
    resourceId: XmlString,
    scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension,
    forecastDataType: zio.aws.autoscalingplans.model.ForecastDataType,
    startTime: TimestampType,
    endTime: TimestampType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest = {
    import GetScalingPlanResourceForecastDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(XmlString.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .forecastDataType(forecastDataType.unwrap)
      .startTime(TimestampType.unwrap(startTime): Instant)
      .endTime(TimestampType.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest.ReadOnly =
    zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest
      .wrap(buildAwsValue())
}
object GetScalingPlanResourceForecastDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest =
      zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest(
        scalingPlanName,
        scalingPlanVersion,
        serviceNamespace,
        resourceId,
        scalableDimension,
        forecastDataType,
        startTime,
        endTime
      )
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace
    def resourceId: XmlString
    def scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension
    def forecastDataType: zio.aws.autoscalingplans.model.ForecastDataType
    def startTime: TimestampType
    def endTime: TimestampType
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
    def getServiceNamespace
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ServiceNamespace] =
      ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, XmlString] = ZIO.succeed(resourceId)
    def getScalableDimension
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalableDimension] =
      ZIO.succeed(scalableDimension)
    def getForecastDataType
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ForecastDataType] =
      ZIO.succeed(forecastDataType)
    def getStartTime: ZIO[Any, Nothing, TimestampType] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, TimestampType] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest
  ) extends zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
    override val serviceNamespace
        : zio.aws.autoscalingplans.model.ServiceNamespace =
      zio.aws.autoscalingplans.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: XmlString =
      zio.aws.autoscalingplans.model.primitives.XmlString(impl.resourceId())
    override val scalableDimension
        : zio.aws.autoscalingplans.model.ScalableDimension =
      zio.aws.autoscalingplans.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val forecastDataType
        : zio.aws.autoscalingplans.model.ForecastDataType =
      zio.aws.autoscalingplans.model.ForecastDataType
        .wrap(impl.forecastDataType())
    override val startTime: TimestampType =
      zio.aws.autoscalingplans.model.primitives.TimestampType(impl.startTime())
    override val endTime: TimestampType =
      zio.aws.autoscalingplans.model.primitives.TimestampType(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest
  ): zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest.ReadOnly =
    new Wrapper(impl)
}
