package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.autoscalingplans.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlansResponse(
    scalingPlans: Optional[
      Iterable[zio.aws.autoscalingplans.model.ScalingPlan]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse = {
    import DescribeScalingPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
      .builder()
      .optionallyWith(
        scalingPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPlans)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlansResponse
      .wrap(buildAwsValue())
}
object DescribeScalingPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.DescribeScalingPlansResponse =
      zio.aws.autoscalingplans.model.DescribeScalingPlansResponse(
        scalingPlans.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingPlans
        : Optional[List[zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getScalingPlans: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPlans", scalingPlans)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly {
    override val scalingPlans
        : Optional[List[zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPlans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.autoscalingplans.model.ScalingPlan.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ): zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly =
    new Wrapper(impl)
}
