package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ForecastDataType {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType
}
object ForecastDataType {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType
  ): zio.aws.autoscalingplans.model.ForecastDataType = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.CAPACITY_FORECAST =>
      val r = CapacityForecast
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.LOAD_FORECAST =>
      val r = LoadForecast
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.SCHEDULED_ACTION_MIN_CAPACITY =>
      val r = ScheduledActionMinCapacity
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.SCHEDULED_ACTION_MAX_CAPACITY =>
      val r = ScheduledActionMaxCapacity
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ForecastDataType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType =
      software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object CapacityForecast
      extends zio.aws.autoscalingplans.model.ForecastDataType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType =
      software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.CAPACITY_FORECAST
  }
  case object LoadForecast
      extends zio.aws.autoscalingplans.model.ForecastDataType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType =
      software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.LOAD_FORECAST
  }
  case object ScheduledActionMinCapacity
      extends zio.aws.autoscalingplans.model.ForecastDataType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType =
      software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.SCHEDULED_ACTION_MIN_CAPACITY
  }
  case object ScheduledActionMaxCapacity
      extends zio.aws.autoscalingplans.model.ForecastDataType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType =
      software.amazon.awssdk.services.autoscalingplans.model.ForecastDataType.SCHEDULED_ACTION_MAX_CAPACITY
  }
}
